const mongoose = require("mongoose");
const Schema = mongoose.Schema;

const userSchema = new Schema({
    email: {
        type: String,
        required: true
    },
    password: {
        type: String,
        required: true
    },
    profleImage: {
        type: String
    },
    fullName: {
        type: String,
    },
    nickName: {
        type: String,
    },
    DOB: {
        type: String,
    },
    phone: {
        type: Number,
    },
    gender: {
        type: String,
        enum: ["Male", "Female"]
    },
    longitude: {
        type: Number,
    },
    latitude: {
        type: Number,
    },
    locationName: {
        type: String,
    },
    location: {
        type:{
            type: String,
            enum: ["Point"] 
        },
        coordinates: {
            type: [Number],
            default: undefined 
        },
        locationName: {
            type: String
        }
    },
    FCMToken: {
        type: String
    }
});

userSchema.index({ location: "2dsphere" });

const userModel = mongoose.model("User", userSchema);
module.exports = userModel;